################################################################################
#
# vskexec
#
################################################################################

VSKEXEC_VERSION = 2.0.17
VSKEXEC_SOURCE = kexec-tools-$(VSKEXEC_VERSION).tar.xz
VSKEXEC_SITE = $(BR2_KERNEL_MIRROR)/linux/utils/kernel/kexec
VSKEXEC_LICENSE = GPL-2.0
VSKEXEC_LICENSE_FILES = COPYING
VSKEXEC_AUTORECONF = YES

# Makefile expects $STRIP -o to work, so needed for !BR2_STRIP_strip
VSKEXEC_MAKE_OPTS = STRIP="$(TARGET_CROSS)strip"

ifeq ($(BR2_PACKAGE_VSKEXEC_ZLIB),y)
VSKEXEC_CONF_OPTS += --with-zlib
VSKEXEC_DEPENDENCIES = zlib
else
VSKEXEC_CONF_OPTS += --without-zlib
endif

ifeq ($(BR2_PACKAGE_XZ),y)
VSKEXEC_CONF_OPTS += --with-lzma
VSKEXEC_DEPENDENCIES += xz
else
VSKEXEC_CONF_OPTS += --without-lzma
endif

define VSKEXEC_REMOVE_LIB_TOOLS
	rm -rf $(TARGET_DIR)/usr/lib/kexec-tools
endef

VSKEXEC_POST_INSTALL_TARGET_HOOKS += VSKEXEC_REMOVE_LIB_TOOLS

$(eval $(autotools-package))
