################################################################################
#
# vs_dhcpcd
#
################################################################################

VS_DHCPCD_VERSION = 8.0.3
VS_DHCPCD_SOURCE = dhcpcd-$(VS_DHCPCD_VERSION).tar.xz
VS_DHCPCD_SITE = http://roy.marples.name/downloads/dhcpcd
VS_DHCPCD_DEPENDENCIES = host-pkgconf
VS_DHCPCD_LICENSE = BSD-2-Clause
VS_DHCPCD_LICENSE_FILES = LICENSE

ifeq ($(BR2_STATIC_LIBS),y)
VS_DHCPCD_CONFIG_OPTS += --enable-static
endif

ifeq ($(BR2_USE_MMU),)
VS_DHCPCD_CONFIG_OPTS += --disable-fork
endif

define VS_DHCPCD_CONFIGURE_CMDS
	(cd $(@D); \
	$(TARGET_CONFIGURE_OPTS) ./configure \
		--os=linux \
		--libexecdir=/lib/dhcpcd \
		$(VS_DHCPCD_CONFIG_OPTS) )
endef

define VS_DHCPCD_BUILD_CMDS
	$(TARGET_MAKE_ENV) $(MAKE) \
		-C $(@D) all
endef

define VS_DHCPCD_INSTALL_TARGET_CMDS
	$(TARGET_MAKE_ENV) $(MAKE) -C $(@D) install DESTDIR=$(TARGET_DIR)
endef

# NOTE: Even though this package has a configure script, it is not generated
# using the autotools, so we have to use the generic package infrastructure.

$(eval $(generic-package))
