################################################################################
#
# openvpn_vs
#
################################################################################

OPENVPN_VS_VERSION = 2.4.9
OPENVPN_VS_SOURCE = openvpn-$(OPENVPN_VS_VERSION).tar.xz
OPENVPN_VS_SITE = http://swupdate.openvpn.net/community/releases
OPENVPN_VS_DEPENDENCIES = host-pkgconf
OPENVPN_VS_LICENSE = GPLv2
OPENVPN_VS_LICENSE_FILES = COPYRIGHT.GPL
OPENVPN_VS_CONF_OPTS = \
	--disable-plugin-auth-pam \
	--enable-iproute2 \
	--enable-password-save \
	$(if $(BR2_STATIC_LIBS),--disable-plugins)
OPENVPN_VS_CONF_ENV = IFCONFIG=/sbin/ifconfig \
	NETSTAT=/bin/netstat \
	ROUTE=/sbin/route

ifeq ($(BR2_PACKAGE_OPENVPN_VS_SMALL),y)
OPENVPN_VS_CONF_OPTS += \
	--enable-small \
	--disable-plugins \
	--disable-eurephia
endif

# BusyBox 1.21+ places the ip applet in the "correct" place
# but previous versions didn't.
ifeq ($(BR2_PACKAGE_IPROUTE2),y)
OPENVPN_VS_CONF_ENV += IPROUTE=/sbin/ip
else ifeq ($(BR2_BUSYBOX_VERSION_1_19_X)$(BR2_BUSYBOX_VERSION_1_20_X),y)
OPENVPN_VS_CONF_ENV += IPROUTE=/bin/ip
else
OPENVPN_VS_CONF_ENV += IPROUTE=/sbin/ip
endif

ifeq ($(BR2_PACKAGE_OPENVPN_VS_LZO),y)
OPENVPN_VS_DEPENDENCIES += lzo
else
OPENVPN_VS_CONF_OPTS += --disable-lzo
endif

ifeq ($(BR2_PACKAGE_OPENVPN_VS_CRYPTO_OPENSSL),y)
OPENVPN_VS_CONF_OPTS += --with-crypto-library=openssl
OPENVPN_VS_DEPENDENCIES += openssl
endif

ifeq ($(BR2_PACKAGE_OPENVPN_VS_CRYPTO_POLARSSL),y)
OPENVPN_VS_CONF_OPTS += --with-crypto-library=polarssl
OPENVPN_VS_DEPENDENCIES += polarssl
endif

define OPENVPN_VS_INSTALL_TARGET_CMDS
	$(INSTALL) -m 755 $(@D)/src/openvpn/openvpn \
		$(TARGET_DIR)/usr/sbin/openvpn
endef

define OPENVPN_VS_INSTALL_INIT_SYSV
	$(INSTALL) -m 755 -D package/openvpn/S60openvpn \
		$(TARGET_DIR)/etc/init.d/S60openvpn
endef

$(eval $(autotools-package))
