# NetCom Plus and NetCAN Plus BSP Instructions

## Toolchain Installation

### am335x SoC

1. `tar xJf am335x-netcom-toolchain.tar.xz -C /`
2. `export PATH=$PATH:/opt/arm-2014.05/bin`

If host is a 64-bit system, you'll need to install 32-bit libraries. For Ubuntu/Debian perform:

1. `sudo dpkg --add-architecture i386`
2. `sudo apt update`
3. `sudo apt install libc6-dev:i386`

### ar9331 SoC

`tar xJf br-mips-4.9.tar.xz -C /`

## Buildroot and BSP

Extract Buildroot

`tar xJf buildroot.tar.xz`

Extract BSP

`tar xJf netcom-netcan-bsp.tar.xz`

## Compilation Instructions

### am335x

1. `cd buildroot`
2. `make BR2_EXTERNAL=../netcom-netcan-bsp list-defconfigs`
3. `make vscom_vscs_am335x_defconfig`
4. `make`

### ar9331

Extract kernel sources:

`tar xzf linux-7a8d463711bb4808bd01531bb7fb7b87a9058e19.tar.gz`

Add path to the kernel sources to `buildroot/local.mk`:

`LINUX_OVERRIDE_SRCDIR = ../linux-7a8d463711bb4808bd01531bb7fb7b87a9058e19`

`cd buildroot`
`make BR2_EXTERNAL=../netcom-netcan-bsp list-defconfigs`
`make vscom_vscs_ar9331_defconfig`
`make LD_LIBRARY_PATH=/opt/br-mips-4.9/usr/lib`

All images can be found under `output/images`.
