# Open Source Compliance Support for VScom Software Based on Open Source Software

## Introduction

The GNU GPL demands the "complete corresponding source code" will be also distributed.

This project provides Buildroot and OpenWrt based BSPs to compile and build
OSS part of the VScom firmware.

## Folder structure

* `modgate-bsp` - BSP for ModGate Plus devices
* `netcom-netcan-bsp` - BSP for NetCom/NetCAN Plus devices
* `netbios-bsp` - BSP for 1st and 2nd stage bootloader of viaVPN devices

## Requirements

In order to build these BSPs you'll need a Linux system. Buildroot doesn't specify a
particular Linux distribution. So you are free to choose the one you like. These
instructions were tested on Ubuntu 18.04 LTS (Bionic Beaver) 64-bit.

The required disk space is at least 20GB.

Buildroot requires at least the following utilities to be installed:

* which
* sed
* make (version 3.81 or any later)
* binutils
* build-essential (only for Debian based systems)
* gcc (version 4.4 or any later)
* g++ (version 4.4 or any later)
* bash
* patch
* gzip
* bzip2
* perl (version 5.8.7 or any later)
* tar
* cpio
* python (version 2.7 or any later)
* unzip
* rsync
* file (must be in /usr/bin/file)
* bc
* wget
* texinfo
* lzop
* bc

Please make sure bash is installed and properly configured. On Debian
systems, you achieve this by invoking the following command:

    dpkg-reconfigure dash

Please refer to the official Buildroot Manual for further requirements:
http://nightly.buildroot.org/manual.html#requirement

## Docker

Alternatively, a Docker image can be used to build the BSP. A special
configuration file `Dockerfile` can be found in this archive. To build
the image, invoke:

    docker build -t ubuntuenv_oss:18.04 -m 2GB .

To build the BSP you'll need a bash script like the one below adapted for the
NetCom/NetCAN devices based on ARM SoC:

    #!/bin/sh

    ./bsprep.sh netcom_arm
    cd buildroot
    make

Name the file, for example, `docker_build_netcom_arm.sh`, make it executable,
and invoke Docker as follows:

    docker run -v $(pwd):/usr/local/src --rm -w /usr/local/src --user \
        $(id -u):$(id -g) --name oss-bsp ubuntuenv_oss:18.04 /bin/bash \
        docker_build_netcom_arm.sh

Please refer to https://docs.docker.com/ for detailed Docker information.

## BSP Configuration and Build

This project provides a script `bsprep.sh` that downloads Buidlroot and prepares it for the build.
The only parameter it takes is BSP type:

* `netcom_arm` for ARM based NetCom/NetCAN Plus devices
* `modgate` for ModGate Plus devices with FW versions 2.2.x
* `modgate_old` for ModGate Plus devices with FW versions 2.1.x & 2.0.x
* `openwrt` for the OpenWrt sdcard image for Baltos devices
* `netbios` for the 1st & 2nd bootloader of viaVPN devices
* `viavpn` for the viaVPN OpenWrt firmware

This script checks for tools like `wget`, `tar`, `xz`, `make`, etc.

For example, to prepare Buildroot for ModGate device, invoke: `./bsprep.sh modgate`

If the setup is approved, it downloads Buildroot and applies the default
configuration. After this, you can change to the `buildroot` folder and
issue `make` or `make LD_LIBRARY_PATH=/opt/br-mips-4.9/usr/lib` for the
MIPS based BSP to start the build process.

## BSP Images

Folder `output/images` provides the build results. Depending on the
selected device/architecture, the following files can be found in
the `output/images` folder:

* `MLO` - second stage loader (U-Boot)
* `u-boot.img` - main U-Boot image
* `barebox.bin` - barebox bootloader image
* `zImage` - Linux kernel image for ARM devices with integrated root file system
* `*.dtb` - device tree blobs for ARM devices
* `vmlinuz` - Linux kernel image for MIPS devices
* `rootfs.squashfs` - root file system as SquashFS image
* `rootfs.cpio` - root file system as CPIO archive

## OpenWrt Setup

OpenWrt uses its own build system. openwrt-setup contains the complete system to recreate the sdcard image provided by VScom.

To build OpenWrt you may need to install a few extra packages to the Ubuntu system.
For that install the following packages:

git, libssl-dev, libncurses5-dev, unzip, gawk, zlib1g-dev, pkg-config, u-boot-tools, python2.7, subversion, wget, dosfstools, libconfuse-dev, mtools, swig, gettext

Or run the following commands:

1. `sudo apt update`
2. `sudo apt install -y git-core build-essential libssl-dev libncurses5-dev unzip gawk zlib1g-dev swig gettext`
3. `sudo apt install -y pkg-config u-boot-tools python2.7 subversion wget dosfstools libconfuse-dev mtools`

Build Instructions:

1. `cd openwrt-setup`
2. `./build_openwrt prepare_local`
2. `./build_openwrt make`
3. `./build_openwrt sdcard`

After these instructions the directory `openwrt/bin/targets/baltos/generic`
will contain the following files:

* `mksdcard.sh` - script to create sdcard.img [already invoked by `./build_openwrt sdcard`]
* `openwrt-baltos-zImage` - Linux kernel image for ARM devices with integrated root file system
* `*.dtb` - device tree blobs for ARM devices
* `barebox-am33xx-baltos-mlo.img` - second stage loader (barebox)
* `barebox-am33xx-baltos.bin` - barebox bootloader image
* `boot.vfat` - boot partition used for sdcard image
* `config.seed` - configuration difference to the default configuration
* `genimage-barebox-baltos.cfg` - genimage instructions for sdcard image creation
* `kernel-fit-intree.its` - kernel image creation instructions
* `kernel-fit.itb` - packaged kernel image
* `openwrt-18.06.2-r7676-cddd7b4c77-baltos-default-rootfs.tar.gz` - root filesystem as tar archive
* `openwrt-18.06.2-r7676-cddd7b4c77-baltos-default.manifest` - manifest on used packages
* `openwrt-baltos-ext4.img` - root filesystem as ext4 partition on the sdcard
* `openwrt-baltos-squashfs.img` - root filesystem as squashfs
* `sdcard.img` - sdcard image
* `sha256sums` - file checksums
* `uEnv.txt` - remnant for U-Boot environment

For further reference on building OpenWrt look into the `openwrt-setup/README.md` file.

### Rebuilding the Barebox Bootloader for OpenWrt

To rebuild the open source bootloader, use the following instructions:

This requires the ARM based Toolchain to be present.

1. `cd open-setup`
2. `./build_barebox`

The second instruction will replace the prebuilt boot loader images in OpenWrt build system.

## Building the 1st and 2nd stage bootloader for the viaVPN firmware

To build the open source bootloader called netbios, use the following instructions:

1. `./bsprep.sh netbios`
2. `cd buildroot`
3. `make`

This will create firmware update files under output/images/ :

* `bios-viavpn-0.0.0-ir2110.bin` - update file for viaVPN Mini
* `bios-viavpn-0.0.0-ir3220.bin` - update file for viaVPN Lite
* `bios-viavpn-0.0.0-ir5221.bin` - update file for viaVPN Pro

## viaVPN Setup

The viaVPN firmware is based on OpenWrt which uses its own build system.
viavpn-setup contains the complete system to recreate the firmware and
firmware update files.

To build the viaVPN firmware, you may need to install extra packages to
the Ubuntu system. For that, install the following packages:

git, libssl-dev, libncurses5-dev, unzip, gawk, zlib1g-dev, pkg-config, u-boot-tools, python2.7, subversion, wget, dosfstools, libconfuse-dev, mtools, swig, gettext

Or run the following commands:

1. `sudo apt update`
2. `sudo apt install -y git-core build-essential libssl-dev libncurses5-dev unzip gawk zlib1g-dev swig gettext`
3. `sudo apt install -y pkg-config u-boot-tools python2.7 subversion wget dosfstools libconfuse-dev mtools`

Build Instructions:

1. `cd viavpn-setup`
2. `./build_viavpn make`
3. `./build_viavpn image`

After these instructions the directory `output/` will contain the following files:

* `fw-viavpn-0.0.0-ir2110.bin - update file for viaVPN Mini
* `fw-viavpn-0.0.0-ir3220.bin - update file for viaVPN Lite
* `fw-viavpn-0.0.0-ir5221.bin - update file for viaVPN Pro
* `openwrt-baltos-default-rootfs.tar.gz - root filesystem of the viaVPN firmware

## Deployment to a viaVPN router

You can use a USB-Stick to install a netbios or viaVPN firmware to a viaVPN router with following instructions:

1. Copy the appropriate update file into `InstallDisk/` and rename it to `firmware.bin` - i.e. `cp buildroot/output/fw-viavpn-0.0.0-ir2110.bin InstallDisk/firmware.bin`
2. Mount the USB-Stick.
3. Copy all files in `InstallDisk/` onto a FAT32 formatted USB-Stick - i.e. `cp InstallDisk/* /media/username/USB-Stick/`
4. Unmount the USB-Stick and unplug the USB-Stick.
5. Plug the USB-Stick into the viaVPN router.
6. Power up the viaVPN router and wait until PWR, Wifi/WLAN and APP/RDY LEDs are lit.
7. Remove the USB-Stick and reboot the viaVPN router (twice for netbios)

Files:

* `MLO` - second stage loader (U-Boot)
* `firmware.bin` - the update file you like to install
* `kernel-fit.itb` - bootable system to install the update file
* `u-boot.img` - main U-Boot image
* `uEnv.txt` - configuration for U-Boot
* `uImage` - dummy image

# Handling legacy NetCom/NetCAN Plus BSPs

Current project supports only the latest firmware or the firmware that doesn't
include changes in the OSS packages. For these legacy firmware versions the
folder `netcom-netcan-plus`
(http://ftp.visionsystems.de/oss/netcom_netcan_plus/) on
the server provides `oss-compliance-legacy*.tar.xz` and
`buildroot-legacy*.tar.xz` files. As more legacy firmware versions appear, the
tarballs will get a firmware version number after `legacy`.

To build the legacy firmware, perform the following steps:

1. download the required oss-compliance tarball and extract it
2. `cd oss-compliance`
3. download the related buildroot tarball and rename it to `buildroot.tar.xz`
4. follow the instructions in the `README.md` file in the legacy oss-compliance
folder
