' Version 1.2
const HKEY_LOCAL_MACHINE = &H80000002
strComputer = "."
Set StdOut = WScript.StdOut

Set oReg=GetObject("winmgmts:{impersonationLevel=impersonate}!\\" &_
strComputer & "\root\default:StdRegProv")

If WScript.Arguments.Count = 0 Then
	StdOut.WriteLine "Please add the desired serial port (eg. COM7)"
	WScript.Quit(1)
End If

bFound = 0
strKeyPath = "SYSTEM\CurrentControlSet\Enum\FTDIBUS\"
oReg.EnumKey HKEY_LOCAL_MACHINE, strKeyPath, arrSubKeys

For Each subkey In arrSubKeys
	strKeyPath2 = strKeyPath & subkey & "\0000\Device Parameters"
	oreg.GetStringValue HKEY_LOCAL_MACHINE, strKeyPath2, "PortName", strValue
	If UCase(WScript.Arguments(0)) = UCase(strValue) Then

		bFound = 1
		oReg.CheckAccess HKEY_LOCAL_MACHINE, strKeyPath2, KEY_SET_VALUE, bHasAccessRight
		If bHasAccessRight = False Then
			StdOut.WriteLine "You have not enough rights - Administrator?"
			WScript.Quit(2)
		End If

		StdOut.WriteLine "Modifying values for " & strValue
		StdOut.WriteLine "LatencyTimer = 1ms"
		oReg.SetDWORDValue HKEY_LOCAL_MACHINE, strKeyPath2, "LatencyTimer", 1
		StdOut.WriteLine "Setting every baudrate to 3MBit - except 115200"

		uBinary = Array( &H11,00,&H3F,&H3F,00,00,00,00,00,00,00,00,00,00,00_
						,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00_
						,00,00,00,00,00,00,00,00,00,00,&H1A,00,00,00,00_
						,00,00,00,00,00,00,00,00,00,00,00,00,00,00,00,&HD0,&H80,00,00)

		oReg.SetBinaryValue HKEY_LOCAL_MACHINE, strKeyPath2, "ConfigData", uBinary

	End If
Next
If bFound = 0 Then
    StdOut.WriteLine "Didn't found a valid entry in the registry for port " & WScript.Arguments(0)
End If
